/*
 * ASCII. Very basic, can use a simple 256 entry array to handle frequencies.
 * Would probably want to convert to a hash table for Unicode, but that would
 * be overkill for ASCII, as array lookups are very, very fast.
 */

package cmsc420project3;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Jeremiah
 */
public class FileProcessor {

    // Returns frequency table
    public String processFiles(String input, String output) throws FileNotFoundException
    {
        int beforeCount = 0;
        int afterCount = 0;

        String myReturn = "";
        // Create frequency table - since it's ASCII, a straight array is fastest.
        int[] freqTable = new int[256];
        for(int x=0; x<256;x++)
        {
            freqTable[x]=0;
        }

        // Open file
        File inFile = new File(input);
        File outFile = new File(output);

       FileInputStream inStream = new FileInputStream(inFile);

        // Read text & get frequency
        int currentChar = 0;
        do
        {
            try
            {
                currentChar = inStream.read();

                // Theoretically impossible since the Java docs say instream.read
                // reads a single byte, but who knows with Java?
                if(currentChar > 255)
                {
                    throw new RuntimeException("Error with file read.");
                }
            } catch (IOException ex)
            {
                Logger.getLogger(FileProcessor.class.getName()).log(Level.SEVERE, null, ex);
            }
            if(currentChar != -1)
            {
                freqTable[currentChar] = freqTable[currentChar] + 1;
                beforeCount = beforeCount + 1;
            }
        } while(currentChar != -1);

        try
        {
            // Close file
            inStream.close();
        } catch (IOException ex)
        {
            Logger.getLogger(FileProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }

        // Create huffman tree

        // Create Heap. Fun with Java generics!
        BinaryHeap<BinaryTree<HuffData>> huffHeap = new BinaryHeap<BinaryTree<HuffData>>();
        for(int x=0; x<256; x++)
        {
            if(freqTable[x] > 0)
            {
                // Add to heap.
                BinaryTree<HuffData> newItem = new BinaryTree<HuffData>();

                HuffData newData = new HuffData(freqTable[x], x);

                newItem.setData(newData);
                huffHeap.addItem(newItem, freqTable[x]);
            }
        }

        BinaryTree<HuffData> finalTree = null;
        // Create tree
        while(huffHeap.dataSize > 1)
        {
            BinaryTree<HuffData> topFreq = huffHeap.removeMinItem();
            BinaryTree<HuffData> secondFreq = huffHeap.removeMinItem();

            BinaryTree<HuffData> newFreq = new BinaryTree<HuffData>();

            newFreq.setLeftNode(topFreq);
            newFreq.setRightNode(secondFreq);

            HuffData newData = new HuffData(topFreq.getData().frequency + secondFreq.getData().frequency, -1);
            
            newFreq.setData(newData);
            huffHeap.addItem(newFreq, newData.frequency);
        }

        // Reopen file again for encoding
        inStream = new FileInputStream(inFile);

        // Open output file
        FileOutputStream outStream = new FileOutputStream(outFile);

        // Create table for huffman encoding

        String[] huffmanTable = new String[256];
        for(int x=0; x<256; x++)
        {
            huffmanTable[x] = "";
        }

        BinaryTree<HuffData> huffTree = huffHeap.removeMinItem();

        // Walk tree, creating the table.
        createTable(huffTree, huffmanTable, "");

        // DEBUG: Write frequency table to file.
        for(int x=0; x<256; x++)
        {
//            try
//            {
                if(freqTable[x]>0)
                {
                    //outStream.write((Character.toString((char)x) + " freq= " + freqTable[x] + " out= " + huffmanTable[x] + "\r\n").getBytes());
                    myReturn = myReturn + Character.toString((char)x) + " freq= " + freqTable[x] + " out= " + huffmanTable[x] + "\r\n";
                }
//            } catch (IOException ex)
//            {
//                Logger.getLogger(FileProcessor.class.getName()).log(Level.SEVERE, null, ex);
//            }
        }

        // Encode to output file
        currentChar = 0;
        do
        {
            try
            {
                currentChar = inStream.read();

                // Theoretically impossible since the Java docs say instream.read
                // reads a single byte, but who knows with Java?
                if(currentChar > 255)
                {
                    throw new RuntimeException("Error with file read.");
                }
            } catch (IOException ex)
            {
                Logger.getLogger(FileProcessor.class.getName()).log(Level.SEVERE, null, ex);
            }
            try
            {
                if(currentChar != -1)
                {
                    outStream.write(huffmanTable[currentChar].getBytes());
                    outStream.write(' ');

                    afterCount = afterCount + huffmanTable[currentChar].length();

//                    myReturn = myReturn + huffmanTable[currentChar] + " ";
                }
            } catch (IOException ex)
            {
                Logger.getLogger(FileProcessor.class.getName()).log(Level.SEVERE, null, ex);
            }
        } while(currentChar != -1);
        try
        {
            inStream.close();
            outStream.close();
        } catch (IOException ex)
        {
            Logger.getLogger(FileProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
        
        System.out.println("Before: " + beforeCount + " bytes. After: " + afterCount/8 + " bytes.");
        return myReturn;
    }

    private void createTable(BinaryTree<HuffData> huffTree, String[] huffmanTable, String currentString)
    {
        if(huffTree.getLeftNode() != null)
        {
            createTable(huffTree.getLeftNode(), huffmanTable, currentString + "0");
        }

        if(huffTree.getRightNode() != null)
        {
            createTable(huffTree.getRightNode(), huffmanTable, currentString + "1");
        }

        if(huffTree.getData() != null)
        {
            HuffData myData = huffTree.getData();
            if(myData.getChar() != -1 && myData.frequency > 0)
            {
                huffmanTable[myData.getChar()] = currentString;
            }
        }
    }


}
